﻿var LogLevel = {

    error: 1,
    warning: 2,
    info: 3,
    debug: 4,
    trace: 5,

    Set: function (LogSetting) {
        try {
            this.error = LogSetting.error;
            this.warning = LogSetting.warning;
            this.info = LogSetting.info;
            this.debug = LogSetting.debug;
            this.trace = LogSetting.trace;
        }
        catch (e) {

        }
    }
}

//
//  Cette objet permet d'envoyer des traces de debug a l'ecran de debug. Comme nous sommes multi-browser
//  nous avons un objet qui permet d'eviter les exception javascript.
//
//  _error: redirige les informations dans le tab error de la console
//  

var ConsoleDebug = {

    m_bEnable: false,

    _log: function (loglevel , message) {

        if (this.m_bEnable == false)
            return;

        try
        {
            switch (loglevel) {
                case LogLevel.error:
                    this._error(message);
                    break;

                case LogLevel.warning:
                    this._warning(message);
                    break;

                case LogLevel.info:
                    this._info(message);
                    break;

                case LogLevel.debug:
                default:
                    this._debug(message);
                    break;
            }
        } 
        catch (e)
        {
        }
            
    },

    _debug: function (message) {

        try {
            if (typeof this.m_bEnable != "boolean" || this.m_bEnable == false)
                return;

            if (typeof message != "string")
                return;

            if (typeof console == "object")
                console.log(this._time() + " |debug    |" + message);

        }
        catch (e) {
            this._catch("caught an exception when using console object -- " + e.message);
        }

    },

    _error: function (message) {

        try {

            if (typeof this.m_bEnable != "boolean" || this.m_bEnable == false)
                return;

            if (typeof message != "string")
                return;
            if (typeof console == "object" && typeof console.error == "function")
                console.error(this._time() + " |error    |" + message);
        }
        catch (e) {
            this._catch("caught an exception when using console object -- " + e.message);
        }

        return;
    },


    _warning: function (message) {

        try {

            if (typeof this.m_bEnable != "boolean" || this.m_bEnable == false)
                return;
            if (typeof message != "string")
                return;
            if (typeof console == "object")
                console.warn(this._time() + " |warning  |" + message);
        }
        catch (e) {
            this._catch("caught an exception when using console object -- " + e.message);
        }

        return;
    },


    _info: function (message) {

        try {

            if (typeof this.m_bEnable != "boolean" || this.m_bEnable == false)
                return;
            if (typeof message != "string")
                return;
            if (typeof console == "object")
                console.info(this._time() + " |info     |" + message);
        }
        catch (e) {
            this._catch("caught an exception when using console object -- " + e.message);
        }

        return;
    },


    _catch: function (message) {

        try {
            if (typeof this.m_bEnable != "boolean" || this.m_bEnable == false)
                return;
            if (typeof message != "string")
                return;
            if (typeof console == "object" && typeof console.error == "function")
                console.error(this._time + " |exception |" + message);
        }
        catch (e) {
        }
    },

    init: function (enable) {
        if (typeof enable == "boolean")
            this.m_bEnable = enable;

        return;
    },

    

    _time: function () {
        try {
            var date = new Date();
            return date.toLocaleTimeString();
        }
        catch (e) {

        }
    }

}


var Logger = {

   
    m_PageUrl: "CloseSentinel.aspx",
    LogSetting: { m_bError:false ,m_bWarning:false, m_bInfo:false ,m_bDebug:false , m_bTrace:false , error:1 , warning:2 ,info:3,debug:4,trace:5 },

          
    send: function ( _methodName, _data, _onSuccess, _onError, _additionalSettings) {
        var _args = null;
        if (_data !== undefined && _data !== null) {
            _args = _data;
        }

        var errorCallBack = _onError;
        if (_onError == undefined || _onError == null) {
            errorCallBack = function (xhr, msg, e) {
                Logger.onAjaxPageMethodError(xhr, msg, e);
            }
        }

        var _settings = _additionalSettings || {};
        _settings.type = _settings.type || "POST";
        if (_methodName != null) {
            _settings.url = this.m_PageUrl + "/" + _methodName;
        }
        else {
            _settings.url = this.m_PageUrl;
        }
        _settings.data = _settings.data || _args != null ? JSON.stringify(_args) : null;
        _settings.contentType = _settings.contentType || "application/json; charset=utf-8";
        _settings.dataType = _settings.dataType || "json";
        _settings.success = _onSuccess || Logger.onAjaxPageMethodSuccess;
        _settings.error = errorCallBack || Logger.onAjaxPageMethodError;

        $.ajax(_settings);
    },

    onAjaxPageMethodError: function (xhr, msg, e) {

        if (xhr.status < 500 && xhr.status !== 401) {
            if (xhr.responseText != undefined && xhr.responseText != null) {
                alert(xhr.responseText);
            }
            else if (msg != undefined && msg != null) {
                _messageToDisplay = msg;
                if (e != undefined && e != null) {
                    _messageToDisplay += ": " + e;
                }
            }
        }

        if (xhr != null) {
            if (xhr.status < 500 && xhr.status !== 401) {
                try {
                    throw (xhr.responseText);
                }
                catch (e) { }
            }
        }
        else {
        }
    },
    onAjaxPageMethodSuccess: function (_result) {
    },

    errorlevel: function () {
        return this.LogSetting.error;
    },

    warninglevel: function () {
        return this.LogSetting.warning;
    },

    infolevel: function () {
        return this.LogSetting.info;
    },

    debuglevel: function () {
        return this.LogSetting.debug;
    },

    tracelevel: function () {
        return this.LogSetting.trace;
    },

    LogSync: function(loglevel, message)
    {
        Logger.Log(loglevel, message, true);
        return;
    } ,

    Log: function( loglevel, message, bSync )
    {
        if (typeof bSync != "boolean")
            bSync = false;

        if (typeof loglevel != "number" || typeof message != "string")
            return;

        if (Logger.LogSetting.m_bError == false && loglevel == Logger.LogSetting.error)
            return ;

        if (Logger.LogSetting.m_bWarning == false && loglevel == Logger.LogSetting.warning)
            return ;

        if (Logger.LogSetting.m_bInfo == false && loglevel == Logger.LogSetting.info)
            return ;

        if (Logger.LogSetting.m_bDebug == false && loglevel == Logger.LogSetting.debug)
            return ;

        if (Logger.LogSetting.m_bTrace == false && loglevel == Logger.LogSetting.trace)
            return ;
      

        ConsoleDebug._log(loglevel, message);

        var additionnalSetting = {};
        additionnalSetting.async = bSync;

        Logger.send("Write", { iLogLevel: loglevel, szMessage: message }, null, function (xhr, msg, e) { }, additionnalSetting);
        return;
    },

    _error:function(  message )
    {
        if (this.LogSetting.m_bError == false)
            return;


        ConsoleDebug._error(message);

        this.send("Write", { iLogLevel: this.LogSetting.error, szMessage: message }, null, function (xhr, msg, e) { }, null);
        return;
    },

    _warning: function (message) {
        if (this.LogSetting.m_bWarning == false )
            return;

        ConsoleDebug._warning(message);
        this.send("Write", { iLogLevel: this.LogSetting.warning, szMessage: message }, null, function (xhr, msg, e) { }, null);
        return;
    },


    _info: function (message) {

        if (this.LogSetting.m_bInfo == false )
            return;

        ConsoleDebug._info(message);

        this.send("write", { iLogLevel: this.LogSetting.info, szMessage: message }, null, function (xhr, msg, e) { }, null);
        return;
    },

    _debug: function (message) {

        if (this.LogSetting.m_bDebug == false)
            return;

        this.send("Write", { iLogLevel: this.LogSetting.debug, szMessage: message }, null, function (xhr, msg, e) { }, null);
        return;
    },

    _trace: function (message) {

        if (this.LogSetting.m_bTrace == false )
            return;

        this.send("Write", { iLogLevel: this.LogSetting.trace, szMessage: message }, null, function (xhr, msg, e) { }, null);
        return;
    },

    getLogSetting: function ()
    {
        var additionnalSetting = {};
        additionnalSetting.async = false;

        var mainFrame = createClassManager().getCloseSentinelFrame();
        if (mainFrame.LoggerLogSetting == undefined) {
            this.send(
                "getLogSetting",
                null,
                function (result) {
                    if (typeof result == "object") {
                        Logger.LogSetting = result.d;
                        mainFrame.LoggerLogSetting = result.d;
                        LogLevel.Set(Logger.LogSetting);
                    }
                },
                function (xhr, msg, e) { }
                ,
                additionnalSetting);
        }
        else {
            Logger.LogSetting = mainFrame.LoggerLogSetting;
        }
        return;
    }
}







